/*----------------------------------------------------------------------
codd - coefficient of determination, double precision
by Andy Allinger, 2018-2025, released to the public domain

   Permission  to  use, copy, modify, and distribute this software and
   its documentation  for  any  purpose  and  without  fee  is  hereby
   granted,  without any conditions or restrictions.  This software is
   provided "as is" without express or implied warranty.

___Name_____Type______In/Out___Description______________________________
   n        int       In       Number of instances
   y[n]     double*   In       Correct answers
   z[n]     double*   In       Predictions
   result   double*   Out      Coefficient of determination
----------------------------------------------------------------------*/
#include <stdbool.h>
bool dafdiv (double numer, double denom);

void codd (int n, double *y, double *z, double *result)
{
/* Local variables */
	int i;
	double d, resid, sos, yave;
/* Function Body */
	*result = 0.;
	if (n < 1) return;
	yave = 0.;  /* average */
	for (i = 0; i < n; ++i) yave += y[i];
	yave /= (double) (n);
	sos = 0.;
	resid = 0.;
	for (i = 0; i < n; ++i) {
		d = y[i] - yave;  /* total variation */
		sos += d * d;
		d = z[i] - y[i];  /* residual */
		resid += d * d;
	}
	if (dafdiv(resid, sos)) *result = 1. - resid / sos;
	return;
} /* end of codd */
