/* analyze the damped vibration data of Mohamed Gharib */
#include <stdio.h>
#include <string.h>
#include <math.h>
void codd (int n, double *y, double *z, double *result);
int osolvd (int m, int n, double *a, int lda, double *b, double reltol,
             int *krank, double *x, double *w, double *c, int *ind);
int damest(double *x, double *y, int n, double *r, double *f, double *s1, double *s2);
#define N 6000
#define P 3
#define TXTLEN 32

int main()
{
/* Initialized data */
	const int n = N, p = P;
	const double TWOPI = 6.283185307179586477;
	static char fname[32] = "data/damp.csv";
	static double tol = 1e-6;
/* Local variables */
	int i, j, k, div, ierr, ind[P], nsub, offs;
	double amp, carr[N*P], col[P], f, phi, r, result, soln[P], w1[N],
	         w2[N], wk[P], x1, x[N], y[N], z[N];
	char lindat[TXTLEN];
	char *sptr;
	FILE *iou;
/* Begin. */
	iou = fopen(fname, "r");
	if (NULL == iou) {
		printf("trouble opening input file!\n");
		return 1;
	}
	sptr = fgets(lindat, TXTLEN, iou);
	if (NULL == sptr) printf("trouble reading header\n");
	for (j = 0; j < n; ++j) {
		sptr = fgets(lindat, TXTLEN, iou);
		if (NULL == sptr) printf("trouble reading input file line %i\n", j);
		sptr = strtok(lindat, ",");
		if (NULL == sptr) printf("nothing to read line %i\n", j);
		ierr = sscanf(sptr, "%lf", &x[j]);
		if (0 == ierr) printf("trouble reading x value line %i\n", j);
		sptr = strtok(NULL, ",");
		if (NULL == sptr) printf("y value not found line %i\n", j);
		ierr = sscanf(sptr, "%lf", &y[j]);
		if (0 == ierr) printf("trouble reading y value line %i\n", j);
	}
	ierr = fclose(iou);
	if (0 != ierr) printf("trouble closing file!\n");
/* Call subroutine. */
	ierr = damest (x, y, n, &r, &f, w1, w2);
	printf("damest returns error# %i\n", ierr);
	printf("growth rate: %f, frequency %f\n", r, f);
	for (j = 0; j < n; ++j) {
		carr[j] = exp(r * x[j]) * cos(TWOPI * f * x[j]);
		carr[j+n] = exp(r * x[j]) * sin(TWOPI * f * x[j]);
		carr[j+2*n] = 1.0;
	}
	ierr = osolvd (n, p, carr, n, y, tol, &i, soln, wk, col, ind);
	if (0 != ierr) printf("osolvd returns # %i\n", ierr);
	if (i != p) printf("rank: %i\n", i);
	amp = sqrt(soln[0] * soln[0] + soln[1] * soln[1]);
	phi = atan2(soln[1], soln[0]);
	printf("amplitude: %f, phase shift: %f\n", amp, phi);
	for (j = 0; j < n; ++j) z[j] = amp * exp(r * x[j]) * cos(TWOPI * f * x[j] - phi) + soln[2];
	codd (n, y, z, &result);
	printf("coefficient of determination: %f\n", result);
/* Subdivide domain */
	printf("\nin ten pieces:\n");
	div = 10;
	nsub = 600;
	for (k = 0; k < div; ++k) {
		printf("piece %i\n", k+1);
		offs = nsub * k;
		x1 = x[offs];
		for (j = 0; j < nsub; ++j) x[offs+j] -= x1;
		ierr = damest (&x[offs], &y[offs], nsub, &r, &f, w1, w2);
		if (ierr != 0) {
			printf("damest returns error# %i\n", ierr);
			continue;
		}
		printf("growth rate: %f, frequency: %f\n", r, f);
		for (j = 0; j < nsub; ++j) {
			x1 = x[offs+j];
			carr[j] = exp(r * x1) * cos(TWOPI * f * x1);
			carr[j+n] = exp(r * x1) * sin(TWOPI * f * x1);
			carr[j+2*n] = 1.0;
		}
		ierr = osolvd (nsub, p, carr, n, &y[offs], tol, &i, soln, wk, col, ind);
		if (0 != ierr) printf("osolvd returns #%i\n", ierr);
		if (i != p) printf("rank: %i\n", i);
		amp = sqrt(soln[0] * soln[0] + soln[1] * soln[1]);
		phi = atan2(soln[1], soln[0]);
		printf("amplitude: %f, phase shift: %f\n", amp, phi);
		for (j = 0; j < nsub; ++j) {
			x1 = x[offs+j];
			z[j] = amp * exp(r * x1) * cos(TWOPI * f * x1 - phi) + soln[2];
		}
		codd (nsub, &y[offs], z, &result);
		printf("coefficient of determination: %f\n\n", result);
	}
	return 0;
} /* end of main */
