/* Fit Misra's dental adsorption data */
#include <math.h>
#include <stdio.h>
int ratest (double *x, double *y, int n, double *r, double *s);
#define N 14

int main()
{
/* Initialized data */
	const int n = N;
	double x[N] = { 77.6,114.9,141.1,190.8,239.9,289.,332.8,378.4,
	  434.8,477.3,536.8,593.1,689.1,760. };
	double y[N] = { 10.07,14.73,17.94,23.93,29.61,35.18,40.02,
	  44.82,50.76,55.05,61.01,66.4,75.47,81.78 };
	static double b1 = 238.94212918;
	static double b2 = 5.5015643181e-4;
/* Local variables */
	int j, ierr;
	double b, c, relerr, t, txx, txy, w1[N];

/*----------------------------------------------------------------------
 NIST/ITL StRD
 Dataset Name:  Misra1a           (Misra1a.dat)

 Description:   These data are the result of a NIST study regarding
                dental research in monomolecular adsorption.  The
                response variable is volume, and the predictor
                variable is pressure.

 Reference:     Misra, D., NIST (1978).
                Dental Research Monomolecular Adsorption Study.

 Data:          1 Response Variable  (y = volume)
                1 Predictor Variable (x = pressure)
                14 Observations
                Lower Level of Difficulty
                Observed Data

 Model:         Exponential Class
                2 Parameters (b1 and b2)

                y = b1*(1-exp[-b2*x])  +  e

           Starting values                  Certified Values

         Start 1     Start 2           Parameter     Standard Deviation
   b1 =   500         250           2.3894212918E+02  2.7070075241E+00
   b2 =     0.0001      0.0005      5.5015643181E-04  7.2668688436E-06

 Residual Sum of Squares:                    1.2455138894E-01
 Residual Standard Deviation:                1.0187876330E-01
 Degrees of Freedom:                                12
 Number of Observations:                            14
----------------------------------------------------------------------*/

/* Determine exponent. */
	ierr = ratest(x, y, n, &c, w1);
	printf("ratest returns #%i, found c: %f\n", ierr, c);
/* Fit model z = b (1 - e^(-c x)) */
	txx = 0.;
	txy = 0.;
	for (j = 0; j < n; ++j) {
		t = 1. - exp(c * x[j]);  /* c is returned as a negative number >*/
		txx += t * t;
		txy += t * y[j];
	}
	b = txy / txx;
	relerr = (b - b1) / b1;
	printf("estimated b: %f, certified b: %f, relative error: %f\n", b, b1, relerr);
	relerr = (c + b2) / b2;
	printf("estimated c: %f, certified c: %f, relative error: %f\n", -c, b2, relerr);
	printf("program complete\n");
	return 0;
} /* end of main */
