/* estimate parameters of a log spiral */
#include <stdio.h>
#include <string.h>
int spiest (double *x, double *yri, int n, double *rate, double *freq,
       double *amp, double *phase, double *y0r, double *y0i, double *w);
#define N 992
#define TXTLEN 128

int main()
{
/* Initialized data */
	const int n = N;
	static char ifil[32] = "data/spiral.csv";
/* Local variables */
	int ierr, j;
	double amp, freq, phase, rate, w[8*N], x[N], y0i, y0r, yri[2*N];
	char lindat[TXTLEN];
	char *sptr;
	FILE *iu;
/* Read input. */
	iu = fopen(ifil, "r");
	if (NULL == iu) printf("trouble opening input file!\n");
	sptr = fgets(lindat, TXTLEN, iu);
	if (NULL == sptr) printf("trouble reading header\n");
	for (j = 0; j < n; ++j) {
		sptr = fgets(lindat, TXTLEN, iu);
		if (NULL == sptr) printf("trouble reading input line %i\n", j);
		sptr = strtok(lindat, ",");
		if (NULL == sptr) printf("nothing to read line %i\n", j);
		ierr = sscanf(sptr, "%lf", &x[j]);
		if (0 == ierr) printf("trouble scanning x value line %i\n", j);
		sptr = strtok(NULL, ",");
		if (NULL == sptr) printf("trouble reading real y line %i\n", j);
		ierr = sscanf(sptr, "%lf", &yri[j]);
		if (0 == ierr) printf("trouble scanning real y line %i\n", j);
		sptr = strtok(NULL, ",");
		if (NULL == sptr) printf("trouble reading imaginary y line %i\n", j);
		ierr = sscanf(sptr, "%lf", &yri[n+j]);
		if (0 == ierr) printf("trouble scanning imaginary y line %i\n", j);
	}
	ierr = fclose(iu);
	if (0 != ierr) printf("trouble closing file\n");
/* Call subroutine. */
	printf("calling spiest...\n");
	ierr = spiest (x, yri, n, &rate, &freq, &amp, &phase, &y0r, &y0i, w);
	printf("spiest returns #%i\n", ierr);
	printf("decay rate: %f (-0.3)\n", rate);
	printf("frequency: %f (0.7)\n", freq);
	printf("amplitude: %f (5.0)\n", amp);
	printf("phase shift: %f (2.3)\n", phase);
	printf("center:  (%f, %f)  (-3.8, 4.2)\n", y0r, y0i);
	printf("program complete\n");
	return 0;
} /* end of main */
