/* period of a variable star */
#include <stdio.h>
#include <string.h>
int freest (double *x, double *y, int n, double *f, double *s);
#define N 116
#define TXTLEN 128

int main()
{
/* Initialized data */
	static int n = N;
	static char fname[32] = "data/var_star.csv";
/* Local variables */
	int ierr, j;
	double f, x[N], y[N], s[N], x1;
	char lindat[TXTLEN];
	char *sptr;
	FILE *iou;
/*----------------------------------------------------------------------
Variable star 1SWASPJ141941.31055341.9
https://www.superwasp.org/vespa/source/1SWASPJ141941.31+055341.9/

This data is an extract of the file v0.9_1SWASPJ141941.31055341.9.fits
The 116 observations are the longest subsequence without gaps longer
than one hour.

Time is in hours from the beginning of the .fits file
Flux is the TAMFLUX2 field, the value given after correction with
the Tamuz algorithm.
----------------------------------------------------------------------*/
	iou = fopen(fname, "r");
	if (NULL == iou) {
		printf("trouble opening input file!\n");
		return 1;
	}
	sptr = fgets(lindat, TXTLEN, iou);  /* burn header */
	if (NULL == sptr) printf("trouble reading header\n");
	for (j = 0; j < n; ++j) {
		sptr = fgets(lindat, TXTLEN, iou);
		if (NULL == sptr) printf("trouble reading input file line %i\n", j);
		sptr = strtok(lindat, ",");
		if (NULL == sptr) printf("Nothing to read, line %i\n", j);
		ierr = sscanf(sptr, "%lf", &x[j]);
		if (0 == ierr) printf("trouble reading x value, line %i\n", j);
		sptr = strtok(NULL, ",");
		if (NULL == sptr) printf("y value not found, line %i\n", j);
		ierr = sscanf(sptr, "%lf", &y[j]);
		if (0 == ierr) printf("trouble reading y value, line %i\n", j);
	}
	ierr = fclose(iou);
	if (0 != ierr) printf("Trouble closing file\n");
	x1 = x[0];
	for (j = 0; j < n; ++j) x[j] -= x1;  /* start at time zero */
/* Call subroutine. */
	ierr = freest (x, y, n, &f, s);
	printf("freest returns error# %i\n", ierr);
	printf("period in hours %f\n", 1./f);
	return 0;
} /* end of main */
